/* eslint camelcase: 0 */

/**
 * @class ShardServerModel
 * @extends Backbone.Model
 */
const ShardServerModel = Backbone.Model.extend({

    defaults: {
        id: '',
        state: '',
        ping: 0,
        last_heartbeat: '',
        sync_source: '',
        optime: '',
        uptime: 0,
        elected: null
    },

    isPrimary() {
        return (this.get('state') === ShardServerModel.STATE.PRIMARY);
    },

    toJSON() {
        return _.extend({}, this.attributes, { isPrimary: this.isPrimary() });
    }

}, {
    STATE: {
        PRIMARY: 'PRIMARY',
        SECONDARY: 'SECONDARY'
    },

    STATE_GROUP: {
        ERROR: ['UNKNOWN', 'DOWN', 'REMOVED', 'ROLLBACK', 'FATAL'],
        OTHER: ['STARTUP', 'STARTUP2', 'RECOVERING'],
        PRIMARY: ['PRIMARY'],
        SECONDARY: ['SECONDARY'],
        ARBITER: ['ARBITER']
    }
});

module.exports = ShardServerModel;
