const SuggestGroupModel = require('./SuggestGroupModel');
const SuggestGroupValueCollection = require('../../collection/suggest/SuggestGroupValueCollection');

/**
 * @class ManagedSuggestGroupModel
 * @extends SuggestGroupModel
 */
const ManagedSuggestGroupModel = SuggestGroupModel.extend({

    defaults: {
        title: 'Managed suggest group',
        items: null
    },

    initialize() {
        this._CLASS = 'ManagedSuggestGroupModel';

        this.listenTo(this, 'items:ready', this.setItems);
        this.set('items', new SuggestGroupValueCollection());
    },

    fetch(options) {
        this.trigger('fetchGroup', options);
    },

    setItems(data) {
        this.get('items').set(data.items);

        if (this.collection) {
            // Throwing «change:items» event to parent collection to trigger menu toggling
            this.collection.trigger('change:items');
        }
    }
});

module.exports = ManagedSuggestGroupModel;
