// eslint-disable-next-line no-unused-vars
const SuggestGroupValueCollection = require('../../collection/suggest/SuggestGroupValueCollection');

/**
 * @class SuggestGroupModel
 * @extends Backbone.Model
 */
const SuggestGroupModel = Backbone.Model.extend({

    defaults: {
        title: 'Default suggest group title',
        items: null
    },

    initialize() {
        this._CLASS = 'SuggestGroupModel';
    },

    parse() {
        throw new Error('SuggestGroupModel#parse() is NOT implemented');
    },

    toJSON() {
        const items = this.get('items');
        const serialized = {
            memberOf: this._CLASS,
            title: this.get('title'),
            items: []
        };

        if (items !== null) {
            serialized.items = items.toJSON();
        }

        return serialized;
    },

    fetchDataPreprocessor(data) {
        return data;
    },

    fetchWithOptions(options) {
        this.fetch(this.fetchDataPreprocessor(options));
    }
});

SuggestGroupModel.SUGGEST_SET_SIZE = 5;

module.exports = SuggestGroupModel;
