/**
 * @class SuggestGroupModelManager
 * @extends Backbone.Model
 */
const SuggestGroupModelManager = Backbone.Model.extend({

    url() {
        return (
            this.get('baseURL') +
            this.get('query') +
            '?limit=' +
            this.get('limit')
        );
    },

    defaults: {
        limit: 5,
        query: '',
        baseURL: '/api/v1.0/suggest/quicksearch/'
    },

    responseMapSettings: {

        // TaskSuggestGroupModel
        task: {
            targetInstance: null,
            parsedItems: []
        },

        // ResourceSuggestGroupModel
        resource: {
            targetInstance: null,
            parsedItems: []
        }
    },

    initialize(props, options) {
        this.debouncedFetchGroups = _.debounce(this.fetchGroups, 50).bind(this);
        this.listenTo(this, 'sync', this.updatedBindedGroups);

        for (const key in options.groups) {
            if (this.responseMapSettings[key]) {
                this.responseMapSettings[key].targetInstance = options.groups[key];
                this.listenTo(
                    this.responseMapSettings[key].targetInstance,
                    'fetchGroup',
                    this.debouncedFetchGroups
                );
            }
        }
    },

    fetchGroups(options) {
        this.set('query', options.query);

        return this.fetch(options);
    },

    updatedBindedGroups() {
        for (const key in this.responseMapSettings) {
            if (this.responseMapSettings[key].targetInstance !== null) {
                this.responseMapSettings[key].targetInstance.trigger('items:ready', {
                    items: this.responseMapSettings[key].parsedItems
                });
            }
        }
    },

    parse(data) {
        const self = this;

        for (const key in this.responseMapSettings) { // eslint-disable-line
            if (this.responseMapSettings[key]) {
                this.responseMapSettings[key].parsedItems = [];
            } else {
                this.responseMapSettings[key] = {
                    parsedItems: []
                };
            }
        }

        data.forEach(suggestItem => {
            for (const key in suggestItem) {
                if (self.responseMapSettings[key] && self.responseMapSettings[key].parsedItems) {
                    self.responseMapSettings[key].parsedItems.push(suggestItem[key]);
                }
            }
        });

        return {};
    }
});

module.exports = SuggestGroupModelManager;
