const SuggestGroupValueModel = Backbone.Model.extend({

    defaults: {
        key: '',
        value: ''
    },

    idAttribute: 'key',

    constructor(attributes) {
        this.cid = _.uniqueId('c');
        this.attributes = attributes;
        this.initialize(attributes);
    },

    toJSON() {
        const attrs = _.clone(this.attributes);

        delete attrs.key;
        delete attrs.value;

        return {
            key: this.get('key'),
            value: this.get('value'),
            attrs
        };
    }
});

module.exports = SuggestGroupValueModel;
