/* eslint no-useless-escape: 0 */

const SuggestGroupModel = require('./SuggestGroupModel');
const SuggestGroupValueModel = require('./SuggestGroupValueModel');
const SuggestGroupValueCollection = require('../../collection/suggest/SuggestGroupValueCollection');

/**
 * @class VirtualSuggestGroupModel
 * @extends SuggestGroupModel
 *
 * @description Need to represent suggest group based on virtual collection.
 *              Each time user change query string will apply new filter based on query
 *              to default set of items.
 *
 * @property {Object} options
 * @property {Array}  options.basicItemsSet - Default set of values
 */
const VirtualSuggestGroupModel = SuggestGroupModel.extend({

    defaults: {
        title: 'Virtual suggest group',
        items: null
    },

    initialize(props, options) {
        this._CLASS = 'VirtualSuggestGroupModel';
        this.options = _.extend({}, this.options, options);
        this.setSize = options.setSize || SuggestGroupModel.SUGGEST_SET_SIZE;

        this.setItems(options.basicItemsSet);
    },

    fetch(options) {
        let fetched = 0;
        const self = this;
        const items = this.get('items');

        items.comparator = function (a, b) {
            const avalue = a.get('value');
            const bvalue = b.get('value');

            return avalue.length - bvalue.length;
        };

        items
            .sort()
            .updateFilter(suggestItem => {
                let result = false;

                if (fetched < (self.setSize * 2) && options.query) {
                    const sanitizeReg = /[\.\\\+\*\?\[\^\]\$\(\)\{\}\=\!\<\>\|\:\-]/gmi;
                    const sanitizedQuery = options.query.replace(sanitizeReg, '\\$&');

                    result = (new RegExp(sanitizedQuery, 'i')).test(suggestItem.get('value'));

                    if (result) {
                        fetched++;
                    }
                }

                return result;
            });

        this.trigger('change:items');
    },

    setItems(items) {
        this._collection = new SuggestGroupValueCollection(items.map(item => {
            return new SuggestGroupValueModel({
                key: item,
                value: item
            });
        }));

        this.set('items', new Backbone.VirtualCollection(this._collection, {
            filter: (_.isFunction(this.options && this.options.defaultFilter) ? this.options.defaultFilter : null)
        }));
    }
});

module.exports = VirtualSuggestGroupModel;
