// eslint-disable-next-line no-unused-vars
const resources = require('../../../resources/index');
const SuggestGroupModel = require('./../SuggestGroupModel');
const SuggestGroupValueModel = require('../SuggestGroupValueModel');
const SuggestGroupValueCollection = require('../../../collection/suggest/SuggestGroupValueCollection');

/**
 * @class MaillistSuggestGroupModel
 * @extends SuggestGroupModel
 */
const MaillistSuggestGroupModel = SuggestGroupModel.extend({

    url: 'https://ml.yandex-team.ru/api/lists/autocomplete/',

    defaults: {
        title: 'Mailing lists',
        items: new SuggestGroupValueCollection()
    },

    options: {
        suggestSetSize: SuggestGroupModel.SUGGEST_SET_SIZE
    },

    initialize(props, options) {
        this._CLASS = 'MaillistSuggestGroupModel';
        this.options = _.extend({}, this.options, options);

        this.isUpdating = false;
        this.isNeedUpdate = false;
        this.nextUpdateOptions = {};
    },

    fetch(options) {
        /* eslint max-statements: [1, 12] */

        let result = $.Deferred(); // eslint-disable-line

        if (options.q) {
            if (this.isUpdating) {
                this.isNeedUpdate = true;
                this.nextUpdateOptions = options;

                return false;
            }

            this.isUpdating = true;

            const self = this;

            result = $.ajax({
                url: this.url,
                data: options,
                dataType: 'jsonp'
            });

            result
                .always(() => {
                    self.isUpdating = false;

                    if (self.isNeedUpdate) {
                        self.isNeedUpdate = false;
                        self.fetch(self.nextUpdateOptions);
                    }
                })
                .then((data, status, fetched) => {
                    self.onFetch(data, fetched);
                });
        } else {
            result.resolve([]);
        }

        return result;
    },

    onFetch(data) {
        if (data) {
            this.get('items').reset(data.map(item => {
                return new SuggestGroupValueModel({
                    key: item.email,
                    value: item.email
                });
            }));

            this.trigger('change:items');
        }
    },

    fetchDataPreprocessor(data) {
        return {
            q: data.query,
            limit: this.options.suggestSetSize
        };
    }
}, {
    /**
     * User login validator
     *
     * @param {string} mailingListToValidate
     * @returns {jQuery.Deferred}
     */
    validateMailingList(mailingListToValidate) {
        const isValid = $.Deferred(); // eslint-disable-line
        const result = {
            toValid: mailingListToValidate,
            isValid: false
        };

        if (mailingListToValidate) {
            $.ajax({
                url: 'https://ml.yandex-team.ru/api/lists/autocomplete/',
                dataType: 'jsonp',
                data: {
                    q: mailingListToValidate,
                    limit: 1
                }
            }).done(responseArgs => {
                const response = (responseArgs[0] || {});

                if (response && response.email === mailingListToValidate) {
                    result.isValid = true;
                    isValid.resolve(result);
                }

                isValid.reject(result);
            })
                .fail(() => {
                    isValid.reject(result);
                });
        } else {
            isValid.reject(result);
        }

        return isValid;
    }
});

module.exports = MaillistSuggestGroupModel;
