// eslint-disable-next-line no-unused-vars
const resources = require('../../../resources/index');
const SuggestGroupModel = require('./../SuggestGroupModel');
const SuggestGroupValueModel = require('../SuggestGroupValueModel');
const SuggestGroupValueCollection = require('../../../collection/suggest/SuggestGroupValueCollection');

const SingleOwnerSuggestGroupModel = SuggestGroupModel.extend({

    url: 'https://staff-api.yandex-team.ru/v3/persons',

    defaults: {
        title: 'Users',
        items: new SuggestGroupValueCollection()
    },

    options: {
        suggestSetSize: SuggestGroupModel.SUGGEST_SET_SIZE + 55
    },

    initialize(props, options) {
        this._CLASS = 'SingleOwnerSuggestGroupModel';
        this.options = _.extend({}, this.options, options);

        this.isUpdating = false;
        this.isNeedUpdate = false;
        this.nextUpdateOptions = {};
    },

    fetch(options) {
        /* eslint max-statements: [1, 14] */

        let result = $.Deferred(); // eslint-disable-line

        if (options.q) {
            if (this.isUpdating) {
                this.isNeedUpdate = true;
                this.nextUpdateOptions = options;

                return false;
            }

            this.isUpdating = true;

            const self = this;
            const q = options.q;

            delete options.q;

            result = $.ajax({
                url: this.url,
                type: 'POST',
                xhrFields: {
                    withCredentials: true
                },
                data: options
            });

            result
                .always(() => {
                    self.isUpdating = false;

                    if (self.isNeedUpdate) {
                        self.isNeedUpdate = false;
                        self.fetch(self.nextUpdateOptions);
                    }
                })
                .then((data, status, fetched) => {
                    self.onFetch(data, fetched, q);
                });
        } else {
            result.resolve([]);
        }

        return result;
    },

    onFetch(data, fetched, q) {
        if (data && data.result) {
            data.result = data.result
                .sort((a, b) => {
                    if (a.login.indexOf(q) - b.login.indexOf(q) === 0) {
                        return a.login.length - b.login.length;
                    }

                    return a.login.indexOf(q) - b.login.indexOf(q);
                })
                .slice(0, SuggestGroupModel.SUGGEST_SET_SIZE);

            this.get('items').reset(data.result.map(item => {
                return new SuggestGroupValueModel({
                    key: item.login,
                    value: item.login
                });
            }));

            this.trigger('change:items');
        }
    },

    fetchDataPreprocessor(data) {
        return {
            q: data.query,
            // eslint-disable-next-line
            // '_query': "login==regex('" + data.query + ".*') or name.last.ru==regex('(?i)" + data.query + "|" + data.query + ".*') or name.first.ru==regex('(?i)" + data.query + "|" + data.query + ".*')",
            // eslint-disable-next-line
            '_query': "login==regex('" + data.query + ".*')",
            _fields: 'login,id,name',
            _limit: this.options.suggestSetSize,
            _sort: 'login'
        };
    }
});

module.exports = SingleOwnerSuggestGroupModel;
