const fuzzy = require('fuzzy.js');
const VirtualSuggestGroupModel = require('./../VirtualSuggestGroupModel');
const SuggestGroupValueModel = require('../SuggestGroupValueModel');
const SuggestGroupValueCollection = require('../../../collection/suggest/SuggestGroupValueCollection');

/**
 * @class TaskTypeSuggestGroupModel
 * @extends VirtualSuggestGroupModel
 */
const TaskTypeSuggestGroupModel = VirtualSuggestGroupModel.extend({

    defaults: {
        title: 'Task types',
        items: null
    },

    options: _.extend({
        basicItemsSetApply: true
    }, VirtualSuggestGroupModel.prototype.options),

    initialize() {
        VirtualSuggestGroupModel.prototype.initialize.apply(this, arguments);
        this._CLASS = 'TaskTypeSuggestGroupModel';
    },

    fetch(options) {
        /* eslint max-statements: [1, 12] */

        let models = [];
        const searchValue = options.query;
        const suggestLimit = this.setSize;

        if (searchValue === '') {
            this.get('items').reset(this.options.basicItemsSetApply ?
                this._collection.models :
                []);
        } else {
            const matched = [];

            for (let q = 0; q < this._collection.length; q++) {
                matched.push(fuzzy(this._collection.models[q].get('value'), searchValue));
                matched[matched.length - 1].model = this._collection.models[q];
            }

            models = matched
                .sort(fuzzy.matchComparator)
                .filter(match => {
                    return match.score > 0;
                })
                .slice(0, suggestLimit)
                .sort((a, b) => {
                    const ai = a.term.toLowerCase().indexOf(a.query.toLowerCase());
                    const bi = b.term.toLowerCase().indexOf(b.query.toLowerCase());

                    return (a.score === b.score) ?
                        bi < ai :
                        b.score - a.score;
                })
                .map(match => {
                    return match.model;
                });

            this.get('items').reset(models);
            this.trigger('change:items');
        }
    },

    setItems(items) {
        this._collection = new SuggestGroupValueCollection(items.map(item => {
            return new SuggestGroupValueModel({
                key: item,
                value: item
            });
        }));

        this.set('items', new Backbone.Collection(this.options.basicItemsSetApply ? this._collection.models : []));
    }
});

module.exports = TaskTypeSuggestGroupModel;
