const NotificationView = require('./views/components/globalMessage/NotificationMessage');
const app = require('./app');
const notification = {

    message(message, options) {
        const notificationView = new NotificationView(_.extend({}, options, {
            message
        }));

        app.notification.close();
        app.notification.show(notificationView);

        return notificationView;
    },

    close() {
        app.notification.close();
    },

    instance() {
        return new NotificationInstance();
    }
};

function NotificationInstance() {}

_.extend(NotificationInstance.prototype, {

    message(message, options) {
        this.notificationView = notification.message(message, options);
    },

    close() {
        if (this.notificationView) {
            this.notificationView.close();
            this.notificationView = null;
        }
    }
});

module.exports = notification;
