/* eslint complexity: [1, 7] */

import { fromJS } from 'immutable';

import {
    ALERT_PUSH,
    ALERT_DEL
} from '../actions';

module.exports = function (state, action) {
    state = fromJS(state || []);
    let data;

    switch (action.type) {
        case ALERT_PUSH:
            data = action.payload && (action.payload.hasError || action.payload);

            if (data) {
                state = state.push(data);
            }

            return state.toJS();

        case ALERT_DEL:
            state = state.shift();

            return state.toJS();

        default:
            return state.toJS();
    }
};
