import { describe } from 'ava-spec';
import { reducerTest } from 'redux-ava';

import reducer from './alert';
import actions from '../actions';

describe('alert reducer', it => {
    it('should set correct message', reducerTest(
        reducer,
        [],
        {
            type: actions.ALERT_PUSH,
            payload: { message: 'Awesome text' }
        },
        [{ message: 'Awesome text' }]
    ));

    it('should set correct error', reducerTest(
        reducer,
        [],
        {
            type: actions.ALERT_PUSH,
            payload: {
                hasError: { message: 'Sad text' },
                message: 'Another bad text'
            }
        },
        [{ message: 'Sad text' }]
    ));

    it('should set correct error message without hasError', reducerTest(
        reducer,
        [],
        {
            type: actions.ALERT_PUSH,
            payload: {
                hasError: false,
                message: 'Another bad text'
            }
        },
        [{
            hasError: false,
            message: 'Another bad text'
        }]
    ));

    it('should do nothing if payload is empty', reducerTest(
        reducer,
        [],
        { type: actions.ALERT_PUSH },
        []
    ));

    it('should delete last message', reducerTest(
        reducer,
        ['first', 'second'],
        { type: actions.ALERT_DEL },
        ['second']
    ));

    it('should not delete nothing if store is empty', reducerTest(
        reducer,
        [],
        { type: actions.ALERT_DEL },
        []
    ));
});
