/* eslint max-statements: [1, 11] */
/* eslint complexity: [1, 9] */

import { fromJS } from 'immutable';
import { FETCH_ADMIN_GROUPS_SUCCESS, PUSH_GROUP_SUCCESS, REMOVE_GROUP_SUCCESS } from '../actions';

module.exports = function (state, action) {
    let item;
    let items;
    let itemId;

    state = fromJS(state || {});

    switch (action.type) {
        case FETCH_ADMIN_GROUPS_SUCCESS: {
            state = fromJS(action.payload);

            return state.toJS();
        }

        case PUSH_GROUP_SUCCESS:
            items = state.get('items', fromJS([])).toJS();
            item = items.filter((item, i) => {
                if (item.name === action.payload.name) {
                    itemId = i;

                    return true;
                }

                return false;
            });

            if (item && item.length) {
                items = [].concat(
                    items.slice(0, itemId),
                    [Object.assign({}, items[itemId], action.payload)],
                    items.slice(itemId + 1)
                );
            } else {
                items = [].concat(items, [action.payload]);
            }

            return state.set('items', items).toJS();

        case REMOVE_GROUP_SUCCESS:
            items = state.get('items', fromJS([])).toJS();
            item = items.filter((item, i) => {
                if (item.name === action.payload.name) {
                    itemId = i;
                    return true;
                }

                return false;
            });

            if (item && item.length) {
                items = [].concat(
                    items.slice(0, itemId),
                    items.slice(itemId + 1)
                );

                return state.set('items', items).toJS();
            }

            return state.toJS();

        default:
            return state.toJS();
    }
};
