/* eslint max-statements: [1, 15] */

import { fromJS } from 'immutable';

import actions from '../actions';

const prepareState = (state, data, target, type) => {
    if (!data) {
        return state;
    }

    if (type === 'list') {
        state = fromJS({});
    }

    const _items = [];
    const _groups = [];

    data.items.forEach(item => {
        state = state.setIn(['items', String(item.id)], item);
        _items.push(item.id);
    });

    data.groups.forEach(group => {
        state = state.setIn(['groups', group], {
            name: group,
            groups: [],
            items: []
        });
        _groups.push(group);
    });

    state = state.setIn(['groups', target, 'items'], _items);
    state = state.setIn(['groups', target, 'groups'], _groups);

    return state;
};

module.exports = function (state, action) {
    /* eslint complexity: [1, 18] */

    state = fromJS(state || {});
    let item;

    switch (action.type) {
        case actions.FETCH_SEMAPHORES:
            return state.set('isLoading', true).toJS();

        case actions.FETCH_SEMAPHORES_SUCCESS:
            state = prepareState(state, action.payload.data, action.payload.group, action.payload.type);
            state = state
                .setIn(['groups', action.payload.group, 'type'], 'root')
                .set('total', action.payload.data.total)
                .delete('isLoading');

            return state.toJS();

        case actions.FETCH_SEMAPHORE_BY_ID:
            state = state.setIn(['items', action.payload.id, 'isLoading'], true);

            return state.toJS();

        case actions.FETCH_SEMAPHORE_BY_ID_SUCCESS:
            state = state
                .setIn(['items', action.payload.id], action.payload.data)
                .delete('isLoading');

            return state.toJS();

        case actions.FETCH_SEMAPHORE_AUDIT:
            state = state.setIn(['audit', action.payload.id, 'isLoading'], true);

            return state.toJS();

        case actions.FETCH_SEMAPHORE_AUDIT_SUCCESS:
            state = state
                .setIn(['audit', action.payload.id], action.payload.data)
                .delete('isLoading');

            return state.toJS();

        case actions.FETCH_SEMAPHORES_SUBTLE_GROUP:
            state = state.setIn(['groups', action.payload.group, 'isLoading'], true);

            return state.toJS();

        case actions.FETCH_SEMAPHORES_SUBTLE_GROUP_SUCCESS:
            state = prepareState(state, action.payload.data, action.payload.group);
            state = state.setIn(['groups', action.payload.group, 'isLoading'], false);

            return state.toJS();

        case actions.FETCH_SEMAPHORES_FAILURE:
            return state.toJS();

        case actions.PUSH_SEMAPHORE_SUCCESS:
            item = state.getIn(['items', action.payload.id.toString()]);

            if (item) {
                const { owner, shared, auto, capacity, event } = action.payload;

                item = item.merge({
                    owner,
                    shared: [].concat(shared),
                    auto,
                    capacity,
                    event
                });

                state = state.mergeIn(['items', action.payload.id.toString()], item);
            } else {
                state = state
                    .setIn(['items', action.payload.id], action.payload)
                    .mergeIn(['groups', '/', 'items'], [action.payload.id]);
            }

            return state.toJS();

        case actions.REMOVE_SEMAPHORE:
            state = state.mergeIn(['items', action.payload.id.toString()], { isDeleting: true });

            return state.toJS();

        case actions.REMOVE_SEMAPHORE_SUCCESS:
            if (state.getIn(['groups', action.payload.group, 'items'])) {
                item = state.getIn(['groups', action.payload.group, 'items']).toJS();

                const index = item.indexOf(action.payload.id);

                item.splice(index, 1);

                state = state
                    .setIn(['groups', action.payload.group, 'items'], fromJS(item));

                const groupsSize = state.getIn(['groups', action.payload.group, 'groups']).size;
                const itemsSize = state.getIn(['groups', action.payload.group, 'items']).size;

                if (!groupsSize && !itemsSize) {
                    state = state.deleteIn(['groups', action.payload.group]);
                }
            }

            state = state
                .deleteIn(['items', action.payload.id.toString()]);

            return state.toJS();

        default:
            return state.toJS();
    }
};
