import { describe } from 'ava-spec';
import { reducerTest } from 'redux-ava';

import reducer from './semaphores';
import actions from '../actions';

describe('semaphores reducer', it => {
    it('should set isLoading on fetch default list', reducerTest(
        reducer,
        {},
        { type: actions.FETCH_SEMAPHORES },
        { isLoading: true }
    ));

    it('should set correct data on success list fetch', reducerTest(
        reducer,
        { isLoading: true },
        {
            type: actions.FETCH_SEMAPHORES_SUCCESS,
            payload: {
                data: {
                    items: [{
                        name: 'schedule_action',
                        id: 3524
                    }],
                    total: 40,
                    limit: 2,
                    groups: [
                        'autocleaner'
                    ],
                    offset: 0
                },
                group: '/'
            }
        },
        {
            total: 40,
            items: {
                3524: {
                    name: 'schedule_action',
                    id: 3524
                }
            },
            groups: {
                autocleaner: {
                    name: 'autocleaner',
                    groups: [],
                    items: []
                },
                '/': {
                    items: [
                        3524
                    ],
                    groups: [
                        'autocleaner'
                    ],
                    type: 'root'
                }
            }
        }
    ));

    it('should set correct data on success list fetch with empty response', reducerTest(
        reducer,
        { isLoading: true },
        {
            type: actions.FETCH_SEMAPHORES_SUCCESS,
            payload: {
                data: {
                    items: [],
                    total: 40,
                    limit: 2,
                    groups: [],
                    offset: 0
                },
                group: '/'
            }
        },
        {
            total: 40,
            groups: {
                '/': {
                    items: [],
                    groups: [],
                    type: 'root'
                }
            }
        }
    ));

    it('should set isLoading on fetch subtle group', reducerTest(
        reducer,
        { isLoading: true },
        {
            type: actions.FETCH_SEMAPHORES_SUCCESS,
            payload: {
                data: {
                    items: [],
                    total: 40,
                    limit: 2,
                    groups: [],
                    offset: 0
                },
                group: '/'
            }
        },
        {
            total: 40,
            groups: {
                '/': {
                    items: [],
                    groups: [],
                    type: 'root'
                }
            }
        }
    ));

    it('should set isLoading on fetch sempahore by id', reducerTest(
        reducer,
        {},
        { type: actions.FETCH_SEMAPHORE_BY_ID, payload: { id: 42 }},
        {
            items: {
                42: { isLoading: true }
            }
        }
    ));

    it('should set correct data on fetch sempahore by id', reducerTest(
        reducer,
        {
            items: {
                42: { isLoading: true }
            }
        },
        {
            type: actions.FETCH_SEMAPHORE_BY_ID_SUCCESS,
            payload: {
                id: 42,
                data: {
                    awesome: true
                }
            }
        },
        {
            items: {
                42: {
                    awesome: true
                }
            }
        }
    ));

    it('should set isLoading on fetch sempahore\'s audit by id', reducerTest(
        reducer,
        {},
        {
            type: actions.FETCH_SEMAPHORE_AUDIT,
            payload: { id: 42 }
        },
        {
            audit: {
                42: { isLoading: true }
            }
        }
    ));

    it('should set correct data on fetch sempahore by id', reducerTest(
        reducer,
        {
            audit: {
                42: { isLoading: true }
            }
        },
        {
            type: actions.FETCH_SEMAPHORE_AUDIT_SUCCESS,
            payload: {
                id: 42,
                data: { awesome: true }
            }
        },
        {
            audit: {
                42: { awesome: true }
            }
        }
    ));
});
