import { fromJS } from 'immutable';
import {
    FETCH_GROUPS,
    FETCH_GROUPS_SUCCESS
} from '../actions';

module.exports = function (state, action) {
    state = fromJS(state || {});

    switch (action.type) {
        case FETCH_GROUPS: {
            state = state.setIn(['groups', 'isLoading'], true);

            return state.toJS();
        }

        case FETCH_GROUPS_SUCCESS: {
            if (action.payload) {
                state = state.setIn(['groups'], action.payload);
            } else {
                state = state.setIn(['groups', 'isLoading'], false);
            }

            return state.toJS();
        }

        default:
            return state.toJS();
    }
};
