import { describe } from 'ava-spec';
import { reducerTest } from 'redux-ava';

import reducer from './suggest';
import {
    FETCH_GROUPS,
    FETCH_GROUPS_SUCCESS
} from '../actions';

describe('suggest reducer', it => {
    it('should set isLoading on groups fetching', reducerTest(
        reducer,
        {},
        { type: FETCH_GROUPS },
        {
            groups: {
                isLoading: true
            }
        }
    ));

    it('should set tags on success', reducerTest(
        reducer,
        {},
        {
            type: FETCH_GROUPS_SUCCESS,
            payload: ['TAG', 'TAG2']
        },
        {
            groups: ['TAG', 'TAG2']
        }
    ));

    it('should finish loading state on success without payload', reducerTest(
        reducer,
        {},
        {
            type: FETCH_GROUPS_SUCCESS,
            payload: false
        },
        {
            groups: {
                isLoading: false
            }
        }
    ));
});
