import { fromJS } from 'immutable';
import {
    ADD_TAG_SUCCESS,
    REMOVE_TAG_SUCCESS,
    APPLY_TAGS
} from '../actions';

module.exports = function (state, action) {
    /* eslint complexity: [1, 16] */

    state = fromJS(state || {});

    switch (action.type) {
        case ADD_TAG_SUCCESS:
            if (!action.payload || !action.payload.id || !action.payload.tag) {
                return state.toJS();
            }

            if (!state.get(String(action.payload.id))) {
                state = state.set(
                    String(action.payload.id),
                    fromJS([])
                );
            }
            state = state.set(
                String(action.payload.id),
                state.get(String(action.payload.id)).push(action.payload.tag)
            );

            return state.toJS();

        case REMOVE_TAG_SUCCESS:
            if (!action.payload || !action.payload.id || !action.payload.tag) {
                return state.toJS();
            }

            if (state.get(String(action.payload.id))) {
                state = state.set(
                    action.payload.id,
                    state.get(String(action.payload.id)).filter(o => o !== action.payload.tag)
                );
            }

            return state.toJS();

        case APPLY_TAGS:
            if (!action.payload || !action.payload.id || !action.payload.tags) {
                return state.toJS();
            }

            state = state.set(action.payload.id, [...action.payload.tags]);

            return state.toJS();

        default:
            return state.toJS();
    }
};
