import { describe } from 'ava-spec';
import { reducerTest } from 'redux-ava';

import reducer from './tags';
import {
    ADD_TAG,
    ADD_TAG_SUCCESS,
    ADD_TAG_FAILURE,
    REMOVE_TAG,
    REMOVE_TAG_SUCCESS,
    REMOVE_TAG_FAILURE,
    APPLY_TAGS
} from '../actions';

describe('tags reducer', it => {
    it('should return current state on ADD_TAG', reducerTest(
        reducer,
        {},
        { type: ADD_TAG },
        {}
    ));

    it('should add single tag on success', reducerTest(
        reducer,
        {},
        {
            type: ADD_TAG_SUCCESS,
            payload: {
                id: 42,
                tag: 'Awesome'
            }
        },
        {
            42: ['Awesome']
        }
    ));

    it('should add tag to existing key', reducerTest(
        reducer,
        {
            42: ['kek']
        },
        {
            type: ADD_TAG_SUCCESS,
            payload: {
                id: 42,
                tag: 'Awesome'
            }
        },
        {
            42: ['kek', 'Awesome']
        }
    ));

    it('should return current state on ADD_TAG_FAILURE', reducerTest(
        reducer,
        {},
        { type: ADD_TAG_FAILURE },
        {}
    ));

    it('should return current state on REMOVE_TAG', reducerTest(
        reducer,
        {},
        { type: REMOVE_TAG },
        {}
    ));

    it('should return current state on REMOVE_TAG_FAILURE', reducerTest(
        reducer,
        {},
        { type: REMOVE_TAG_FAILURE },
        {}
    ));

    it('should remove existing tag', reducerTest(
        reducer,
        {
            42: ['kek', 'Awesome']
        },
        {
            type: REMOVE_TAG_SUCCESS,
            payload: {
                id: 42,
                tag: 'kek'
            }
        },
        {
            42: ['Awesome']
        }
    ));

    it('should do nothing on removing unexisting tag', reducerTest(
        reducer,
        {
            42: ['kek', 'Awesome']
        },
        {
            type: REMOVE_TAG_SUCCESS,
            payload: {
                id: 42,
                tag: 'kek2'
            }
        },
        {
            42: ['kek', 'Awesome']
        }
    ));

    it('should apply tags', reducerTest(
        reducer,
        {},
        {
            type: APPLY_TAGS,
            payload: {
                id: 42,
                tags: ['kek', 'Awesome']
            }
        },
        {
            42: ['kek', 'Awesome']
        }
    ));
});
