/* eslint max-statements: [1, 11] */

import { fromJS } from 'immutable';

import actions from '../actions';

import TaskFooterBuilder from '../helpers/api/TaskFooterBuilder';

module.exports = function (state, action) {
    /* eslint complexity: [1, 12] */

    state = fromJS(state || {});

    let data;
    let taskId;
    let name;

    switch (action.type) {
        case actions.FETCH_TASKS:
            return state.set('isLoading', true).toJS();

        case actions.FETCH_TASKS_SUCCESS:
            data = (action.payload.data.items || []).reduce((res, item) => {
                res[item.id] = item;

                return res;
            }, {});

            state = state
                .setIn(['items'], data)
                .set('total', action.payload.data.total)
                .set('limit', action.payload.data.limit)
                .set('offset', action.payload.data.offset)
                .delete('isLoading');

            return state.toJS();

        case actions.FETCH_TASK_REPORT:
            taskId = action.payload.taskId;
            name = action.payload.name;

            return state.setIn([String(taskId), 'reports', name], { isLoading: true }).toJS();

        case actions.FETCH_TASK_REPORT_SUCCESS:
            taskId = action.payload.taskId;
            name = action.payload.name;
            data = action.payload.data && action.payload.data[0] && action.payload.data[0].content;

            return state.setIn([String(taskId), 'reports', name], new TaskFooterBuilder({ data }).buildFooters()).toJS();

        default:
            return state.toJS();
    }
};
