import { describe } from 'ava-spec';
import { reducerTest } from 'redux-ava';

import reducer from './tasks';
import {
    FETCH_TASKS,
    FETCH_TASKS_SUCCESS,
    FETCH_TASK_REPORT,
    FETCH_TASK_REPORT_SUCCESS
} from '../actions';

describe('tasks reducer', it => {
    it('should return current state on FETCH_TASKS', reducerTest(
        reducer,
        {},
        { type: FETCH_TASKS },
        { isLoading: true }
    ));

    it('should add tasks on success', reducerTest(
        reducer,
        {},
        {
            type: FETCH_TASKS_SUCCESS,
            payload: {
                data: {
                    items: [
                        { id: 42, a: 'b' },
                        { id: 32, a: 'b' },
                        { id: 22, a: 'b' }
                    ],
                    total: 3,
                    limit: 3,
                    offset: 0
                }
            }
        },
        {
            items: {
                42: { id: 42, a: 'b' },
                32: { id: 32, a: 'b' },
                22: { id: 22, a: 'b' }
            },
            total: 3,
            limit: 3,
            offset: 0
        }
    ));

    it('should return isLoading on report loading', reducerTest(
        reducer,
        {},
        {
            type: FETCH_TASK_REPORT,
            payload: {
                taskId: 42,
                name: 'awesome'
            }
        },
        {
            42: {
                reports: {
                    awesome: {
                        isLoading: true
                    }
                }
            }
        }
    ));

    it('should return isLoading with task filled with data', reducerTest(
        reducer,
        {
            42: {
                kek: true
            }
        },
        {
            type: FETCH_TASK_REPORT,
            payload: {
                taskId: '42',
                name: 'awesome'
            }
        },
        {
            42: {
                kek: true,
                reports: {
                    awesome: {
                        isLoading: true
                    }
                }
            }
        }
    ));

    it('should return data on report success', reducerTest(
        reducer,
        {},
        {
            type: FETCH_TASK_REPORT_SUCCESS,
            payload: {
                data: [{ content: 'awesome content' }],
                taskId: 42,
                name: 'awesome'
            }
        },
        {
            42: {
                reports: {
                    awesome: 'awesome content'
                }
            }
        }
    ));

    it('should return isLoading with task filled with data', reducerTest(
        reducer,
        {
            42: {
                kek: true
            }
        },
        {
            type: FETCH_TASK_REPORT_SUCCESS,
            payload: {
                data: [{ content: 'awesome content' }],
                taskId: '42',
                name: 'awesome'
            }
        },
        {
            42: {
                kek: true,
                reports: {
                    awesome: 'awesome content'
                }
            }
        }
    ));

    it('should return isLoading with task filled with data', reducerTest(
        reducer,
        {
            42: {
                kek: true,
                reports: {
                    awesome: 'awesome content'
                }
            }
        },
        {
            type: FETCH_TASK_REPORT_SUCCESS,
            payload: {
                data: [{ content: 'awesome content2' }],
                taskId: '42',
                name: 'awesome2'
            }
        },
        {
            42: {
                kek: true,
                reports: {
                    awesome: 'awesome content',
                    awesome2: 'awesome content2'
                }
            }
        }
    ));
});
