/* eslint max-statements: [1, 11] */
/* eslint complexity: [1, 7] */

import { fromJS } from 'immutable';
import { FETCH_USER_GROUPS_SUCCESS, FETCH_USER_PREFERENCES_SUCCESS, SET_CONFIG } from '../actions';

/* eslint complexity: [1, 13] */
/* eslint max-statements: [1, 13] */
module.exports = function (state, action) {
    state = fromJS(state || {});

    switch (action.type) {
        case FETCH_USER_PREFERENCES_SUCCESS: {
            state = state.set('prefs', action.payload);

            return state.toJS();
        }

        case FETCH_USER_GROUPS_SUCCESS: {
            state = state.set('groups', action.payload);

            return state.toJS();
        }
        case SET_CONFIG: {
            if (!action.payload) {
                return state.toJS();
            }

            if (action.payload.namespace) {
                state = state
                    .mergeIn(
                        ['configure', action.payload.namespace],
                        { [action.payload.key]: action.payload.value }
                    );
            } else if (action.payload.key) {
                state = state
                    .mergeIn(
                        ['configure'],
                        { [action.payload.key]: action.payload.value }
                    );
            }

            return state.toJS();
        }
        default:
            return state.toJS();
    }
};
