import { describe } from 'ava-spec';
import { reducerTest } from 'redux-ava';

import reducer from './user';
import { FETCH_USER_GROUPS_SUCCESS, SET_CONFIG } from '../actions';

describe('user reducer', it => {
    const payload = [
        {
            ui: { class: 'USER', subclass: 'NORMAL' },
            name: 'ARCANUM'
        }, {
            ui: { class: 'USER', subclass: 'NORMAL' },
            name: 'SANDBOX'
        }
    ];

    it('should set groups', reducerTest(
        reducer,
        {},
        {
            type: FETCH_USER_GROUPS_SUCCESS,
            payload
        },
        {
            groups: payload
        }
    ));

    it('should set config value', reducerTest(
        reducer,
        {},
        {
            type: SET_CONFIG,
            payload: {
                key: 'type',
                value: 'wide'
            }
        },
        {
            configure: {
                type: 'wide'
            }
        }
    ));

    it('should set complex config', reducerTest(
        reducer,
        {},
        {
            type: SET_CONFIG,
            payload: {
                namespace: 'semaphores',
                key: 'type',
                value: 'wide'
            }
        },
        {
            configure: {
                semaphores: {
                    type: 'wide'
                }
            }
        }
    ));

    it('should merge complex config', reducerTest(
        reducer,
        {
            configure: {
                semaphores: {
                    lol: 'kek'
                }
            }
        },
        {
            type: SET_CONFIG,
            payload: {
                namespace: 'semaphores',
                key: 'type',
                value: 'wide'
            }
        },
        {
            configure: {
                semaphores: {
                    lol: 'kek',
                    type: 'wide'
                }
            }
        }
    ));

    it('should set nothing if payload is empty', reducerTest(
        reducer,
        {},
        {
            type: SET_CONFIG,
            payload: {}
        },
        {}
    ));
});
