const cookie = require('bemmy/src/blocks/component/cookie');
const qs = require('querystring');
const app = require('./app');

function getPerformance(settings, deferred) {
    return {
        startTime: performance.now() / 1000,
        login: cookie.getYandexLogin(),
        method: settings.type,
        isRetried: Boolean(deferred),
        internalRoute: app.performance.internalRoute,
        url: document.location.pathname,
        urlParams: qs.parse(document.location.search ? document.location.search.slice(1) : ''),
        endpoint: settings.url,
        endpointParams: settings.data || {}
    };
}

function formatPerformance(data, type, status, statusText) {
    const startTime = data.startTime;

    delete data.startTime;

    return Object.assign(
        {
            time: (performance.now() / 1000) - startTime,
            type
        },
        (
            status === undefined ?
                {} :
                {
                    status,
                    statusText
                }
        ),
        data
    );
}

function reachGoal(params) {
    if (window.yaCounter28049724 && window.yaCounter28049724.reachGoal && window.location.host === 'sandbox.yandex-team.ru') {
        window.yaCounter28049724.reachGoal('PERFORMANCE_XHR', params);
    }
}

$.ajax = (function (oldAjax) {
    return function (settings) {
        const defaults = {
            interval: 500,
            beforeRetry() { },
            onRetry() {}
        };

        settings = $.extend({}, defaults, settings);

        function AjaxRetry(settings) {
            const interval = typeof settings.interval === 'number' ? settings.interval : 500;
            const beforeRetry = settings.beforeRetry;
            const onRetry = settings.onRetry;

            return tryAjax().promise();

            function tryAjax(deferred) {
                const promise = deferred || $.Deferred(); // eslint-disable-line

                const xhr = oldAjax(settings)
                    .done((data, textStatus, jqXHR) => {
                        reachGoal(formatPerformance(xhr._performance, 'success'));

                        promise.resolve(data, textStatus, jqXHR);
                    })
                    .fail((jqXHR, textStatus, errorThrown) => {
                        beforeRetry(jqXHR);
                        setTimeout(() => {
                            if ((jqXHR.status > 500 || jqXHR.status <= 0) && jqXHR.statusText !== 'abort') {
                                if (jqXHR.status !== 0) {
                                    reachGoal(formatPerformance(xhr._performance, 'retry', jqXHR.status, jqXHR.statusText));
                                }

                                onRetry();
                                tryAjax(promise);
                            } else {
                                reachGoal(formatPerformance(xhr._performance, 'fail'));

                                promise.reject(jqXHR, textStatus, errorThrown);
                            }
                        }, interval);
                    });

                xhr._performance = getPerformance(settings, deferred);

                if (settings.cancellable) {
                    if (app.t) {
                        app.t.forEach(item => {
                            reachGoal(formatPerformance(xhr._performance, 'abort'));

                            item.xhr.abort();
                            item.promise.resolve(xhr);
                        });
                    }

                    app.t = [{ xhr, promise }];
                }

                return promise;
            }
        }

        return new AjaxRetry(settings);
    };
})($.ajax);
