const cookie = require('bemmy/src/blocks/component/cookie');
const uuid = require('uuid/v4');

$.ajaxPrefilter((options, originalOptions, xhr) => {
    /* eslint max-statements: [1, 13] */
    /* eslint complexity: [1, 8] */

    let token;

    if (!originalOptions.statistics && options.url.indexOf('/api/') === 0) {
        options.headers = options.headers || {};

        token = cookie.get('csrftoken');

        if (!token) {
            token = uuid();
            cookie.set('csrftoken', token);
        }

        options.headers['X-CSRFToken'] = token;
    }

    if (options.url.indexOf('/api/') === 0) {
        options.headers = options.headers || {};
        xhr.requestURL = options.url || '';

        options.headers['X-Request-ID'] = uuid();
    }
});
