describe('NotificationsCollection should support plain notifications format', () => {
    const NotificationsCollection = require('../../collection/NotificationsCollection');
    const mockData = require('./mock/plainNotifications');

    it('with no receivers', () => {
        const result = NotificationsCollection.prototype.parse.call(null, mockData.nulled);

        expect(result).toBeDefined();
        expect(result instanceof Array).toBe(true);
        expect(result.length).toBe(0);
    });

    it('with 1 receiver', () => {
        const result = NotificationsCollection.prototype.parse.call(null, mockData.successOnly);

        expect(result).toBeDefined();
        expect(result instanceof Array).toBe(true);
        expect(result.length).toBe(1);

        expect(result[0].receivers[0]).toBe('dhomich');
        expect(result[0].statuses[0]).toBe('SUCCESS');
        expect(result[0].transport).toBe('email');
    });

    it('with 2 receivers', () => {
        const result = NotificationsCollection.prototype.parse.call(null, mockData.both);

        expect(result).toBeDefined();
        expect(result instanceof Array).toBe(true);
        expect(result.length).toBe(2);

        expect(result[0].receivers[0]).toBe('ftdebugger');
        expect(result[0].statuses[0]).toBe('FAILURE');
        expect(result[0].transport).toBe('jabber');

        expect(result[1].receivers[0]).toBe('dhomich');
        expect(result[1].statuses[0]).toBe('SUCCESS');
        expect(result[1].transport).toBe('jabber');
    });
});
