/* eslint no-useless-escape: 0 */

/**
 * @class DBStateContent
 * @extends Backbone.Marionette.CompositeView
 */
const DBStateContent = Marionette.CompositeView.extend({

    id: 'visual-bd',
    className: 'visual',

    template: require('./tpl/DBStateContent.hbs'),

    itemViewContainer: '.shards',
    itemView: require('./ShardView'),

    ui: {
        cells: '.visual__c__i:first-child .visual__val',
        rowHeaders: '.visual__r',
        colHeaders: '.visual__n',
        crossHeader: '.visual__h',
        colHeadersText: '.visual__n__i'
    },

    initialize() {
        this.itemViewOptions = {
            parent: this
        };

        this.setRowHeight = _.debounce(this.setRowHeight, 50).bind(this);
        this.setHeadersHeight = _.debounce(this.setHeadersHeight, 50).bind(this);

        this.listenTo(this, 'server:hovered', this.onServerHovered);
        $(window).on('resize', this.setRowHeight);
    },

    getServers() {
        const servers = _.without(_.union.apply(null, this.collection.map(shard => {
            return shard.get('replicaset').map(srv => {
                return srv.get('id').replace(/\.search\.yandex\.net\:[0-9]+$/, '');
            });
        })), '').sort();

        return servers;
    },

    serializeData() {
        return {
            servers: this.getServers()
        };
    },

    onServerHovered(index) {
        this.ui.rowHeaders.removeClass('hover');
        this.ui.rowHeaders
            .filter('*[data-serv-id="' + index.replace(/\.search\.yandex\.net\:[0-9]+$/, '') + '"]')
            .addClass('hover');
    },

    setRowHeight() {
        const self = this;

        this.ui.rowHeaders.each((index, elt) => {
            $(elt).height(self.ui.cells.eq(index).outerHeight());
        });
    },

    setHeadersHeight() {
        const maxHeaderHeight = Math.max.apply(null, this.ui.colHeadersText.map(function () {
            return $(this).outerWidth(true);
        }));

        this.ui.crossHeader.height(maxHeaderHeight);
        this.ui.colHeaders.height(maxHeaderHeight);

        this.ui.colHeadersText.each((index, elt) => {
            const $headerText = $(elt);
            const splittedWidth = ($headerText.outerWidth() / 2);

            $headerText.css({
                marginLeft: (splittedWidth * -1),
                marginBottom: (splittedWidth - 9)
            });
        });
    },

    onRender() {
        this.bindUIElements();
        this.setHeadersHeight();
        this.setRowHeight();
    },

    onClose() {
        this.stopListening(this, 'server:hovered');
        $(window).off('resize');
    }
});

module.exports = DBStateContent;
