const ShardServerModel = require('../../../model/service/ShardServerModel');

/**
 * @class ShardServerView
 * @extends Marionette.ItemView
 */
const ShardServerView = Marionette.ItemView.extend({

    template: require('./tpl/ShardServer.hbs'),

    className() {
        const state = this.model.get('state');
        const classPostfix = (ShardServerModel.STATE_GROUP.ERROR.includes(state) ?
            'ERR' :
            (ShardServerModel.STATE_GROUP.OTHER.includes(state) ?
                'O' :
                (ShardServerModel.STATE_GROUP.PRIMARY.includes(state) ?
                    'M' :
                    (ShardServerModel.STATE_GROUP.SECONDARY.includes(state) ?
                        'S' :
                        (ShardServerModel.STATE_GROUP.ARBITER.includes(state) ?
                            'A' :
                            'E'
                        )
                    )
                )
            )
        );

        return ('visual__val visual__val_' + classPostfix);
    },

    ui: {
        extendedInfo: '.visual__p'
    },

    events: {
        click: 'onItemClick',
        mouseover: 'onMouseOver'
    },

    behaviors: {
        ClickOut: {}
    },

    onMouseOver() {
        this.options.parent.trigger('server:hovered', this.model.get('id'));
    },

    onItemClick() {
        this.ui.extendedInfo.toggleClass('hover');
    },

    onClickOut() {
        this.ui.extendedInfo.removeClass('hover');
    }
});

module.exports = ShardServerView;
