const ShardModel = require('../../../model/service/ShardModel');

/**
 * @class ShardView
 * @extends Marionette.CompositeView
 *
 * @property {ShardServerView} itemView
 */
const ShardView = Marionette.CompositeView.extend({

    className: 'shard visual__c__i',

    template: require('./tpl/ShardView.hbs'),

    itemView: require('./ShardServerView'),

    initialize() {
        this.collection = this.getModifiedReplicasets();

        this.itemViewOptions = {
            parent: this
        };

        this.listenTo(this, 'server:hovered', this.onServerHover);
    },

    getModifiedReplicasets() {
        const biggestCollection = _.max(this.model.collection.models, model => {
            return model.get('replicaset').length;
        });
        const maxReplicasets = (biggestCollection.get('replicaset') || []).length;
        const replicasets = this.model.get('replicaset');

        while (replicasets.length < maxReplicasets) {
            replicasets.models.push(new ShardModel({}));
            replicasets.length++;
        }

        return replicasets;
    },

    onServerHover(index) {
        this.options.parent.trigger('server:hovered', index);
    },

    onClose() {
        this.stopListening(this, 'server:hovered');
    }
});

module.exports = ShardView;
