const error = require('../../../error');
const notification = require('../../../notification');
const GroupEditModalView = require('./GroupEditModalView');
// eslint-disable-next-line no-unused-vars
const GroupMembersEditView = require('./GroupMembersEditView');

/**
 * @class GroupAddModalView
 * @extends GroupEditModalView
 *
 * @property {UserGroupModel}    model
 * @property {Marionette.Region} members
 * @property {Marionette.Region} memberSelector
 */
const GroupAddModalView = GroupEditModalView.extend({

    template: require('./tpl/GroupAddModalView.hbs'),

    ui: {
        name: '.group_name',
        email: '.group_email',
        syncSource: '.sync_source select',
        syncGroup: '.sync_group',
        syncGroupInput: '.sync_group input'
    },

    events: {
        'change @ui.syncSource': 'onSyncSourceChange',
        'bemmy:refresh @ui.name': 'onNameChange',
        'bemmy:refresh @ui.email': 'onEmailChange',
        'bemmy:refresh @ui.syncGroup': 'onSyncGroupChange',
        approve: 'onApprove'
    },

    onApprove() {
        const self = this;

        return $.ajax({
            url: '/api/v1.0/group',
            type: 'POST',
            data: JSON.stringify(this.model.toJSON()),
            dataType: 'json',
            contentType: 'application/json'
        })
            .always(() => {
                self.close();
            })
            .done(() => {
                self.collection.add(self.model);

                notification.message(require('./tpl/GroupCreatedNotification.hbs')({
                    name: self.model.get('name')
                }), {
                    reload: false
                });
            })
            .fail(error.fromXHR);
    },

    onSyncGroupChange() {
        const sync = this.model.get('sync') || {};

        sync.group = this.ui.syncGroupInput.val();

        this.model.set('sync', sync);
    },

    onSyncSourceChange() {
        const sync = this.model.get('sync') || {};

        sync.source = this.ui.syncSource.val();

        this.model.set('sync', sync);

        this.render();
    },

    onNameChange() {
        this.model.set('name', this.ui.name.find('input').val());
    },

    onAddMember(selectedMember) {
        this.model.get('members').add(new Backbone.Model({ name: selectedMember.value }));
    }
});

module.exports = GroupAddModalView;
