const error = require('../../../error');
const OwnerSuggestView = require('../../controlSection/filter/suggest/OwnerSuggestView');
const GroupMembersEditView = require('./GroupMembersEditView');
const BasicConfirmDialogView = require('../../components/BasicConfirmDialogView');

/**
 * @class GroupEditModalView
 * @extends BasicConfirmDialogView
 *
 * @property {Marionette.Region} members
 * @property {Marionette.Region} memberSelector
 */
const GroupEditModalView = BasicConfirmDialogView.extend({

    template: require('./tpl/GroupEditModalView.hbs'),

    ui: {
        email: '.group_email',
        remover: '.remove_group',
        syncGroup: '.sync_group',
        syncGroupInput: '.sync_group input',
        syncSource: '.sync_source select'
    },

    events: {
        'change @ui.syncSource': 'onSyncSourceChange',
        'bemmy:refresh @ui.email': 'onEmailChange',
        'bemmy:refresh @ui.syncGroup': 'onSyncGroupChange',
        'click @ui.remover': 'onRemove',
        approve: 'onApprove'
    },

    onRender() {
        this.$('.input').bemmyInput();
        this.$('.select').bemmySelect();

        this.members.close();
        this.members.show(new GroupMembersEditView({
            model: this.model,
            collection: this.model.get('members')
        }));

        if (this.memberSelector) {
            this.memberSelector.close();
            this.memberSelector.show(new OwnerSuggestView({
                model: new Backbone.Model(),
                clearOnSelect: true,
                ownerGroups: [],
                placeholder: 'Member'
            }));

            this.listenTo(this.memberSelector.currentView, 'selected', this.onAddMember);
        }
    },

    onApprove() {
        const self = this;

        this.model
            .save()
            .always(() => {
                self.close();
            })
            .done(() => {
                self.model.trigger('updated');
            })
            .fail(error.fromXHR);
    },

    onEmailChange() {
        this.model.set('email', this.ui.email.find('input').val());
    },

    onSyncGroupChange() {
        const sync = this.model.get('sync') || {};

        sync.group = this.ui.syncGroupInput.val();

        this.model.set('sync', sync);
    },

    onSyncSourceChange() {
        const sync = this.model.get('sync') || {};

        sync.source = this.ui.syncSource.val();

        this.model.set('sync', sync);

        this.render();
    },

    onRemove(evtObj) {
        const GroupRemoveModalView = require('./GroupRemoveModalView');

        evtObj.preventDefault();

        this.close();

        (new GroupRemoveModalView({
            model: this.model
        })).show();
    },

    onClose() {
        this.stopListening(this.memberSelector.currentView);
    },

    onAddMember(selectedMember) {
        this.model.get('members').add(new Backbone.Model({ name: selectedMember.value }));
    }
});

module.exports = GroupEditModalView;
