const error = require('../../../error');
const GroupEditModalView = require('./GroupEditModalView');
const BasicConfirmDialogView = require('../../components/BasicConfirmDialogView');

const GroupRemoveModalView = BasicConfirmDialogView.extend({

    template: require('./tpl/GroupRemoveModalView.hbs'),

    events: {
        approve: 'onApprove'
    },

    onApprove() {
        const self = this;

        this.model
            .destroy()
            .always(() => {
                self.close();
            })
            .fail(error.fromXHR);
    },

    onCancel() {
        this.close();
        this.showEditView();
    },

    showEditView() {
        (new GroupEditModalView({
            model: this.model
        })).show();
    }
});

module.exports = GroupRemoveModalView;
