/* eslint no-useless-escape: 0 */

const BasicGridBodyView = require('../../tasks/basicGrid/BasicGridBodyView');

/**
 * @class TaskTypeGridBodyView
 * @extends BasicGridView
 *
 * @property {CoreApplication} model
 */
const TaskTypeGridBodyView = BasicGridBodyView.extend({

    itemView: require('./TaskTypeRowView'),

    initialize() {
        BasicGridBodyView.prototype.initialize.apply(this, arguments);

        const hostsSet = this.model.getProps().hosts;

        this.itemViewOptions = {
            allHosts: hostsSet,
            hostsGroups: _.compact(_.unique(_.map(hostsSet, host => {
                const matched = host.match(/(.+[a-z\-])([0-9]{1,3}[a-z]?)$/i);

                return (matched ? matched[1] : '');
            })))
        };
    }
});

module.exports = TaskTypeGridBodyView;
