/* eslint array-callback-return: 0 */

// eslint-disable-next-line no-unused-vars
const app = require('../../../app');
// eslint-disable-next-line no-unused-vars
const error = require('../../../error');
// eslint-disable-next-line no-unused-vars
const notification = require('../../../notification');
const hostGroups = require('./tpl/HostGroups.hbs');
const TaskTypeModel = require('../../../model/resources/TaskTypeModel');
const hostCopyTrigger = require('./tpl/HostCopyTrigger.hbs');
const ClipboardClientMixin = require('../../components/clipboardClient/ClipboardClientMixin');
const TaskTypeEditModalView = require('./TaskTypeEditModalView');

/**
 * @class TaskTypeRowView
 * @mixes ClipboardClientMixin
 * @extends Marionette.ItemView
 *
 * @property {TaskTypeModel} model
 */
const TaskTypeRowView = Marionette.ItemView.mixin(ClipboardClientMixin).extend({

    template: require('./tpl/TaskTypeRowView.hbs'),
    tagName: 'tr',

    hostsVisible: false,
    hostsMode: TaskTypeModel.HOSTS_TYPE.DEFAULT,

    ui: {
        editTrigger: '.edit_item_trigger',
        hostsCounter: '.hosts_counter',
        hostsToggler: '.hosts_toggler',
        hostsContainer: '.task_type_hosts_container',
        hostsLoadSpinner: '.spinner',
        hostsCopyTriggerCnt: '.copy_list_trigger_cnt',
        hostsModeSwitcher: '.host_mode_switcher',
        hostsModeSwitcherCnt: '.host_mode_switcher_cnt',
        clipboardHelper: '.clipboard_helper'
    },

    events: {
        'click @ui.editTrigger': 'onEditTaskType',
        'click @ui.hostsToggler': 'onHostsToggle',
        'bemmy:set @ui.hostsModeSwitcher': 'onHostsModeSwitch',
        'mouseover @ui.hostsCopyTriggerCnt': 'onCopyTriggerHover',
        'mouseout @ui.hostsCopyTriggerCnt': 'onCopyTriggerHover'
    },

    modelEvents: {
        change: 'render'
    },

    initialize() {

    },

    onRender() {
        this.bindUIElements();
        this.$('.button_mode_radio').bemmyButtonRadio();
        this.initClipboardClient();
    },

    initClipboardClient() {
        this.initializeClipboardClient(
            '.copy_list_trigger',
            'Hosts list has been copied to clipboard!'
        );
    },

    onHostsModeSwitch(evtObj, mode) {
        this.hostsMode = mode;

        const hosts = this.serializeHosts(this.model.getHosts(this.hostsMode), this.hostsMode);

        this.ui.hostsCounter.text(hosts.total);
        this.ui.hostsContainer.html(hostGroups({
            groups: hosts.groupedHosts,
            singleHosts: hosts.singleHosts
        }));

        this.ui.hostsCopyTriggerCnt.html(hostCopyTrigger({
            toCopy: hosts.toCopy
        }));

        this.initClipboardClient();
    },

    onCopyTriggerHover() {
        this.$el.toggleClass('hovered');
    },

    onEditTaskType(evtObj) {
        evtObj.preventDefault();

        const self = this;

        this.model.loadHostsInfo().done(() => {
            self.showTaskTypeEditModalView();
        });
    },

    showTaskTypeEditModalView() {
        (new TaskTypeEditModalView({
            user: this.options.user,
            model: this.model,
            allHosts: this.options.allHosts
        })).show();
    },

    onHostsToggle(evtObj) {
        evtObj.preventDefault();

        const self = this;

        this.ui.hostsLoadSpinner.removeClass('hidden');

        this.model
            .loadHostsInfo().done(() => {
                self.toggleHostsContainer();
            });
    },

    toggleHostsContainer() {
        this.ui.hostsContainer.toggleClass('g_hide', this.hostsVisible);
        this.ui.hostsModeSwitcherCnt.toggleClass('hidden', this.hostsVisible);
        this.ui.hostsToggler.text(this.hostsVisible ? 'Show hosts' : 'Hide hosts');

        this.hostsVisible = !this.hostsVisible;
    },

    serializeData() {
        const serialized = this.model.toJSON();

        serialized.hostsVisible = this.hostsVisible;
        serialized.overallHosts = this.options.allHosts.length;
        serialized.hostsMode = this.hostsMode;

        if (this.model.getHosts(this.hostsMode)) {
            serialized.hosts = this.serializeHosts(this.model.getHosts(this.hostsMode), this.hostsMode);
        }

        return serialized;
    },

    serializeHosts(rawHosts, mode) {
        const singleHosts = [];
        const grouped = {};
        let total = 0;

        mode = mode || TaskTypeModel.HOSTS_TYPE.DEFAULT;

        rawHosts.forEach(function (hostName) {
            this.options.hostsGroups.some((groupPrefix, index, hostsGroups) => {
                if (hostName.indexOf(groupPrefix) === 0 && hostName.length > groupPrefix.length) {
                    if (!grouped[groupPrefix]) {
                        grouped[groupPrefix] = {
                            name: groupPrefix,
                            list: [],
                            compact: []
                        };
                    }

                    grouped[groupPrefix].list.push(hostName.replace(groupPrefix, ''));

                    return true;
                }

                if (index === hostsGroups.length - 1) {
                    singleHosts.push(hostName);
                }
            });
        }, this);

        Object.keys(grouped).forEach(function (groupName) {
            grouped[groupName].list.sort();
            grouped[groupName].compact = this.packHostsGroup(grouped[groupName].list);

            total += grouped[groupName].list.length;
        }, this);

        return {
            total,
            toCopy: this.model.getShortenedHosts(mode),
            singleHosts,
            groupedHosts: _.values(grouped)
        };
    },

    packHostsGroup(hostList) {
        let intervalStarter = hostList[0];
        let intervalLength = 0;
        const group = [];

        _.reduce(hostList, (prev, hostIndex) => {
            const _prev = (prev ? parseInt(prev, 10) : parseInt(intervalStarter, 10));
            const _hostIndex = parseInt(hostIndex, 10);

            if (hostIndex.search(/[a-z]+/) === -1 && _prev === (_hostIndex - 1)) {
                intervalLength++;

                return hostIndex;
            }

            group.push(intervalLength === 0 ?
                intervalStarter :
                (intervalStarter + '..' + prev));
            intervalStarter = hostIndex;
            intervalLength = 0;

            return hostIndex;
        });

        if (intervalLength) {
            group.push(intervalStarter + '..' + hostList[hostList.length - 1]);
        }

        if (hostList.length === 1) {
            group.push(hostList[0]);
        }

        return group;
    }
});

module.exports = TaskTypeRowView;
