// eslint-disable-next-line no-unused-vars
const error = require('../../../error');
// eslint-disable-next-line no-unused-vars
const OwnerSuggestView = require('../../controlSection/filter/suggest/OwnerSuggestView');
const VaultEditModalView = require('./VaultEditModalView');
// eslint-disable-next-line no-unused-vars
const NotificationRecipientSuggestView = require('../../createTask/NotificationRecipientSuggestView');

/**
 * @class VaultAddModalView
 * @extends VaultEditModalView
 *
 * @property {VaultModel}        model
 * @property {Marionette.Region} shared
 */
const VaultAddModalView = VaultEditModalView.extend({

    template: require('./tpl/VaultAddModalView.hbs'),

    ui: _.extend({}, VaultEditModalView.prototype.ui, {
        genKeyPair: '.generate_key_pair'
    }),

    events: _.extend({}, VaultEditModalView.prototype.events, {
        'click @ui.getKeyPair': 'onGetKeyPair'
    }),

    onApprove() {
        VaultEditModalView.prototype.onApprove.apply(this, arguments).done(() => {
            this.collection.add(this._model);
        });
    },

    onGetKeyPair() {
        console.info('API still not implemented');
    },

    serializeData() {
        const serialized = this._model.toJSON();

        serialized.user = {
            login: this.options.user.get('login'),
            groups: this.options.user.get('groups').map(group => {
                return group.get('name');
            }),
            isAdmin: this.options.user.isAdmin()
        };

        return serialized;
    }
});

module.exports = VaultAddModalView;
