const error = require('../../../error');
const BasicConfirmDialogView = require('../../components/BasicConfirmDialogView');

const VaultRemoveModalView = BasicConfirmDialogView.extend({

    template: require('./tpl/VaultRemoveModalView.hbs'),

    events: {
        approve: 'onApprove'
    },

    onApprove() {
        const self = this;

        this.model
            .destroy()
            .always(() => {
                self.close();
            })
            .fail(error.fromXHR);
    }
});

module.exports = VaultRemoveModalView;
