const VaultEditModalView = require('./VaultEditModalView');
const VaultRemoveModalView = require('./VaultRemoveModalView');

const VaultRowView = Marionette.ItemView.extend({

    template: require('./tpl/VaultRowView.hbs'),
    tagName: 'tr',

    ui: {
        editTrigger: '.edit_item_trigger',
        removeTrigger: '.remove_item_trigger'
    },

    events: {
        'click @ui.editTrigger': 'onEditVault',
        'click @ui.removeTrigger': 'onRemoveVault'
    },

    modelEvents: {
        change: 'render'
    },

    onEditVault(evtObj) {
        evtObj.preventDefault();

        (new VaultEditModalView({
            model: this.model,
            user: this.options.user,
            taskProps: this.options.taskProps
        })).show();
    },

    onRemoveVault(evtObj) {
        evtObj.preventDefault();

        (new VaultRemoveModalView({
            model: this.model
        })).show();
    }
});

module.exports = VaultRowView;
