const BasicGridBodyView = require('../../tasks/basicGrid/BasicGridBodyView');

/**
 * @class VaultsGridBodyView
 * @extends BasicGridView
 *
 * @property {CoreApplication} model
 */
const VaultsGridBodyView = BasicGridBodyView.extend({

    collectionEvents: {
        change: 'onUpdate',
        add: 'onUpdate',
        remove: 'onUpdate',
        sort: 'render'
    },

    itemView: require('./VaultRowView'),

    initialize() {
        BasicGridBodyView.prototype.initialize.apply(this, arguments);

        this.itemViewOptions = { user: this.model.getUser(), taskProps: this.model.getProps() };
    },

    onUpdate() {
        this.collection.setSortField(this.collection.options.order, 'CLIENT');
        this.render();
    }
});

module.exports = VaultsGridBodyView;
