const error = require('../../../error');

/**
 * @class OAuthContent
 * @extends Backbone.Marionette.ItemView
 */
const OAuthContent = Marionette.ItemView.extend({

    template: require('./tpl/oauthContent.hbs'),

    serializeData() {
        // http://sandbox.yandex-team.ru/sandbox/oauth/token
        // ?code=1401487#access_token=token&token_type=bearer

        if (!document.location.hash.length) {
            error.message(
                'OAuth sever returned no token. ' +
                '<a href="/oauth/" class="correct">' +
                '<span class="b-button__label">Try again</span>' +
                '</a>',
                { reload: false, autoClose: false }
            );

            return;
        }

        return { token: document.location.hash ? /access_token=(.*)&/.exec(document.location.hash)[1] : '' };
    }
});

module.exports = OAuthContent;
