const Timer = require('../../../helpers/utils/Timer');
const ServiceThreadModel = require('../../../model/service/ServiceThreadModel');

/**
 * @class ServiceThread
 * @extends Backbone.Marionette.ItemView
 *
 * @property {ServiceThreadModel} model
 */
const ServiceThread = Marionette.ItemView.extend({

    className: 'sp__i',

    template: require('./tpl/ServiceThread.hbs'),

    ui: {
        min: '.min',
        sec: '.sec'
    },

    serializeData() {
        const lockHandlers = this.model.get('lock_handlers');
        const nextRunInfo = this.model.getNextRunInfo();

        return {
            id: this.model.get('id'),
            lastRun: Timer.toLocal(this.model.get('last_run')).fromNow(),
            nextRun: this.serializeNextRunTime(nextRunInfo),
            nextRunState: nextRunInfo.state,
            firstLockHandler: (lockHandlers.length ? lockHandlers[0].replace('.search.yandex.net', '') : ''),
            lockHandlersLength: lockHandlers.length
        };
    },

    serializeNextRunTime(state) {
        const nexRunDuration = moment.duration(Math.abs(state.seconds), 'seconds');

        if (state.state === ServiceThreadModel.NEXT_RUN_STATE.NORMAL) {
            if (this.model.get('last_run') === null && this.model.get('next_run') === null) {
                return {
                    text: 'STOPPED'
                };
            }

            return {
                text: nexRunDuration.humanize()
            };
        }
        this.triggerDurationRotate();

        return {
            min: nexRunDuration.minutes(),
            sec: nexRunDuration.seconds()
        };
    },

    triggerDurationRotate() {
        const self = this;

        if (this.nextRunIntervalID) {
            clearInterval(this.nextRunIntervalID);
        }

        this.nextRunIntervalID = setInterval(() => {
            const nextRunDuration = self.serializeNextRunTime(self.model.getNextRunInfo());

            if (nextRunDuration.min > 4) {
                self.render();

                return;
            }

            self.ui.min.text(nextRunDuration.min < 10 ? ('0' + nextRunDuration.min) : nextRunDuration.min);
            self.ui.sec.text(nextRunDuration.sec < 10 ? ('0' + nextRunDuration.sec) : nextRunDuration.sec);
        }, 1000);
    },

    onClose() {
        if (this.nextRunIntervalID) {
            clearInterval(this.nextRunIntervalID);
        }
    }

});

module.exports = ServiceThread;
