/**
 * @class ServiceThreadsView
 * @extends Backbone.Marionette.CollectionView
 */
const ServiceThreadsView = Marionette.CollectionView.extend({

    id: 'monitoring-sp',
    className: 'sp',

    itemView: require('./ServiceThread'),

    collectionEvents: {
        sync: 'render'
    },

    initialize() {
        const self = this;

        this.fetchIntervalID = setInterval(() => {
            self.collection.fetch({ reset: true });
        }, 15000);
    },

    onClose() {
        if (this.fetchIntervalID) {
            clearInterval(this.fetchIntervalID);
        }
    }

});

module.exports = ServiceThreadsView;
