const app = require('../../../app');
const error = require('../../../error');
const router = require('../../../router');

const BasicControllerBehavior = Marionette.Behavior.extend({

    ui: {
        edit: '.edit_trigger',
        remove: '.remove_trigger',
        duplicate: '.duplicate_trigger'
    },

    events: {
        'click @ui.edit': 'onEdit',
        'click @ui.remove': 'onRemove',
        'mouseup @ui.duplicate': 'onDuplicate'
    },

    defaults: {
        entityName: '',
        draftItemSetterName: '',
        removeConfirmDialogClass: ''
    },

    onEdit(evtObj) {
        evtObj.preventDefault();

        this.view.model
            .fetch({ reset: true })
            .done(() => {
                app[this.options.draftItemSetterName](this.view.model);
                router.navigate('/' + this.options.entityName + '/create', { trigger: true });
            })
            .fail(function () {
                error.message('Error during ' + this.options.entityName + ' loading.');
            });
    },

    onRemove(evtObj) {
        evtObj.preventDefault();

        const RemoveConfirmDialog = this.options.removeConfirmDialogClass;

        (new RemoveConfirmDialog({
            model: this.view.model
        })).show();
    },

    onDuplicate(evtObj) {
        evtObj.preventDefault();

        if (!this.view.model.duplicate) {
            throw new Error('Controlled entity does not implement .duplicate() method');
        }

        let windowReference;
        const isMetaKey = evtObj.ctrlKey || evtObj.metaKey || evtObj.which === 2;

        if (isMetaKey) {
            windowReference = window.open();
        }

        this.view.model
            .duplicate()
            .done(() => {
                const targetURL = ('/' + this.options.entityName + '/create');

                if (isMetaKey && windowReference) {
                    windowReference.location = targetURL;
                } else {
                    router.navigate(targetURL, { trigger: true });
                }
            })
            .fail(() => {
                if (isMetaKey) {
                    windowReference.close();
                }
                error.message('Error during task duplication.');
            });
    }

});

module.exports = BasicControllerBehavior;
