// eslint-disable-next-line no-unused-vars
const SchedulersCollection = require('../../../collection/SchedulersCollection');
const BasicControllerBehavior = require('./BasicControllerBehavior');
const SchedulerRemoveConfirmView = require('../../schedulers/modals/SchedulerRemoveConfirmView');

const SchedulerControllerBehavior = BasicControllerBehavior.extend({

    ui: _.extend({}, BasicControllerBehavior.prototype.ui, {
        execute: '.execute_trigger',
        stop: '.stop_trigger',
        runOnce: '.run_once_trigger'
    }),

    events: _.extend({}, BasicControllerBehavior.prototype.events, {
        'click @ui.execute': 'onStart',
        'click @ui.stop': 'onStop',
        'click @ui.runOnce': 'onRunOnce'
    }),

    defaults: {
        entityName: 'scheduler',
        draftItemSetterName: 'setDraftScheduler',
        removeConfirmDialogClass: SchedulerRemoveConfirmView
    },

    initialize(options) {
        this.options = _.extend({}, this.options, options, {
            loadbutton: 'button_load'
        });

        this.listenTo(Backbone, 'scheduler:exec', this.onSchedulerExec);
        this.listenTo(Backbone, 'scheduler:exec:finished', this.onSchedulerExecFinished);
        this.listenTo(Backbone, 'scheduler:runOnce', this.onSchedulerRunOnce);
        this.listenTo(Backbone, 'scheduler:runOnce:finished', this.onSchedulerRunOnceFinished);
        this.listenTo(Backbone, 'scheduler:stop', this.onSchedulerStop);
        this.listenTo(Backbone, 'scheduler:stop:finished', this.onSchedulerStopFinished);
    },

    onSchedulerExec() {
        this.ui.execute.addClass(this.options.loadbutton);
    },

    onSchedulerExecFinished() {
        this.ui.execute.removeClass(this.options.loadbutton);
    },

    onSchedulerStop() {
        this.ui.stop.addClass(this.options.loadbutton);
    },

    onSchedulerStopFinished() {
        this.ui.stop.removeClass(this.options.loadbutton);
    },

    onSchedulerRunOnce() {
        this.ui.runOnce.addClass(this.options.loadbutton);
    },

    onSchedulerRunOnceFinished() {
        this.ui.runOnce.removeClass(this.options.loadbutton);
    },

    onStart(evtObj) {
        evtObj.preventDefault();

        Backbone.trigger('scheduler:exec');

        this.view.model.startAction().done(() => {
            Backbone.trigger('scheduler:exec:finished');
        });
    },

    onStop(evtObj) {
        evtObj.preventDefault();

        Backbone.trigger('scheduler:stop');

        this.view.model.startAction().done(() => {
            Backbone.trigger('scheduler:stop:finished');
        });
    },

    onRunOnce(evtObj) {
        evtObj.preventDefault();

        Backbone.trigger('scheduler:runOnce');

        this.view.model.startActionOnce();
    }
});

module.exports = SchedulerControllerBehavior;
