/**
 * @class BasicModalBehavior
 * @extends Marionette.Behavior
 */
const BasicModalBehavior = Marionette.Behavior.extend({

    options: {
        approveOnEnter: false
    },

    events: {
        'click .app_modal_approve': 'onApprove',
        'click .app_modal_cancel': 'onCancel',
        'click .app_modal_fullscreen': 'onFullScreen',
        keyup: 'onKeyUp'
    },

    onApprove(evtObj) {
        $('.page').removeClass('page_modal_showed');
        evtObj.preventDefault();
        this.view.trigger('approve');
    },

    onFullScreen() {
        this.view.$el.toggleClass('app_modal_fullscreen');

        return false;
    },

    onCancel(evtObj) {
        $('.page').removeClass('page_modal_showed');
        evtObj.preventDefault();
        this.view.trigger('cancel');
        this.view.close();
    },

    onKeyUp(evtObj) {
        // Close popup on escape btn press
        if (evtObj.keyCode === 27) {
            this.onCancel(evtObj);
        }

        if (this.options.approveOnEnter && evtObj.keyCode === 13) {
            this.onApprove(evtObj);
        }
    }
});

module.exports = BasicModalBehavior;
