/**
 * @class ClientsGroupsView
 * @extends Backbone.Marionette.CollectionView
 */
const ClientsGroupsView = Marionette.CollectionView.extend({

    className: 'clients',
    itemView: require('./ClientsGroupView'),
    itemViewOptions: { mode: 'compact' },

    collectionEvents: {
        'change:mode': 'onModeSwitched'
    },

    buildItemView(item, ItemViewType, itemViewOptions) {
        const options = _.extend({
            user: this.options.user,
            model: item,
            collection: item.get('items')
        }, itemViewOptions);

        return new ItemViewType(options);
    },

    onModeSwitched(mode) {
        this.itemViewOptions.mode = mode;
        this.render();
    }
});

module.exports = ClientsGroupsView;
