const app = require('../../app');

/**
 * @class BasicConfirmDialogView
 * @extends Marionette.Layout
 */
const BasicConfirmDialogView = Marionette.Layout.extend({

    className: 'overlay app_modal_visible',

    events: {
        approve: 'onApprove',
        cancel: 'onCancel'
    },

    behaviors: {
        BasicConfirmDialogBehavior: {}
    },

    initialize(options) {
        this.options = _.extend({}, this.options, options);

        if (typeof this.options.onApprove === 'function') {
            this.onApprove = this.options.onApprove;
        }

        this.listenTo(this, 'approve', this.onApprove);
        this.listenTo(this, 'cancel', this.onCancel);
    },

    onRender() {
        this.focusOnInnerInput();
    },

    show() {
        if (app.popup) {
            $('.page').addClass('page_modal_showed');

            app.popup.close();
            app.popup.show(this);
        } else {
            throw new Error('SANDBOX: Can\'t find popup region to show modal content in.');
        }

        return this;
    },

    onApprove() {
        throw new Error('SANDBOX: Every confirm dialog should have .onApprove() method implemented');
    },

    onCancel() {
        $('.page').removeClass('page_modal_showed');

        this.close();
    },

    focusOnInnerInput() {
        const self = this;

        setTimeout(() => {
            self.$('.input__input').focus();
        }, 0);
    },

    onClose() {
        this.stopListening(this, 'approve');
        this.stopListening(this, 'cancel');
    }
});

module.exports = BasicConfirmDialogView;
