/**
 * Mixin with UserTypes functionality for BasicConfirmDialogView.
 *
 */
const BasicConfirmDialogView = require('./BasicConfirmDialogView');

/**
 * @class BasicConfirmDialogViewWithUserType
 * @extends BasicConfirmDialogView
 */
const BasicConfirmDialogViewWithUserType = BasicConfirmDialogView.extend({

    options: _.extend({}, BasicConfirmDialogView.prototype.options, {
        btnActiveClass: 'button_type_hl'
    }),

    ui: _.extend({}, BasicConfirmDialogView.prototype.ui, {
        setUserTypeBtn: '.app_modal_setUserType'
    }),

    events: _.extend({}, BasicConfirmDialogView.prototype.events, {
        'click @ui.setUserTypeBtn': 'onSetUserType'
    }),

    onSetUserType(e) {
        const btn = $(e.currentTarget);
        const userType = btn.text().trim();

        this.ui.setUserTypeBtn.removeClass(this.options.btnActiveClass);
        btn.addClass(this.options.btnActiveClass);

        this.ui.type.val(userType);
        this.onChangeType('trigger');
    },

    getUserTypeList(key) {
        const userTypeList = this.options.user.getPreferences().get(key);
        const prefs = (userTypeList && Array.isArray(userTypeList)) ? userTypeList : [];

        return prefs.slice(0, 5);
    },

    updateUserTypeList(key, type, callback) {
        let types = this.options.user.getPreferences().get(key) || [];

        if (types.indexOf(type) === -1) {
            types.unshift(type);
            types = types.slice(0, 5);

            this.options.user
                .getPreferences()
                .set(key, types)
                .save(null, { method: 'PUT' })
                .always(callback);
        } else {
            callback();
        }
    }
});

module.exports = BasicConfirmDialogViewWithUserType;
