const LOADER_HIDE = 'loader_hide';

const PageLoader = Marionette.ItemView.extend({

    el: '#loader',

    initialize() {
        this.listenTo(Backbone, 'loader:start', this.onShow);
        this.listenTo(Backbone, 'loader:stop', this.onHide);
    },

    onShow() {
        this.$el.removeClass(LOADER_HIDE);
    },

    onHide() {
        this.$el.addClass(LOADER_HIDE);
    }
});

module.exports = new PageLoader();
