/**
 * @class PopupMenuView
 * @extends Marionette.ItemView
 */
const PopupMenuView = Marionette.ItemView.extend({

    template: require('./tpl/PopupMenuView.hbs'),

    behaviors: {
        ClickOut: {}
    },

    options: {
        activeClass: 'popup_menu_hovered'
    },

    ui: {
        cnt: '.popup_menu_widget',
        menu: '.menu',
        menuItems: '.menu__item'
    },

    events: {
        'mouseleave @ui.cnt': 'hideMenu',
        'mouseover @ui.cnt': 'showMenu',
        'mouseleave @ui.menu': 'markMenuNotActive',
        'mouseover @ui.menu': 'markMenuActive',
        'click @ui.menu': 'toggleMenu'
    },

    initialize() {
        this.hideMenu = _.debounce(this.hideMenu, 400).bind(this);
    },

    hideMenu() {
        if (!this.menuActive && !_.isString(this.ui.cnt)) {
            this.ui.cnt.removeClass(this.options.activeClass);
        }
    },

    showMenu() {
        this.ui.cnt.addClass(this.options.activeClass);
    },

    toggleMenu() {
        this.ui.cnt.toggleClass(this.options.activeClass);
    },

    markMenuNotActive() {
        this.menuActive = false;
    },

    markMenuActive() {
        this.menuActive = true;
    },

    onClickOut() {
        this.ui.cnt.toggleClass(this.options.activeClass, false);
    }
});

module.exports = PopupMenuView;
