/**
 * Mixin adds functionality for updating favicon.
 *
 * @mixin
 */
const AutoUpdateFaviconMixin = {

    initializeAutoupdateFaviconClient() {
        this._nativeOnFocusHandler = window.onfocus;
        this._$favicon = $('link[rel="shortcut icon"]');
        this._states = {
            normal: this._$favicon.data('url'),
            notify: this._$favicon.data('url-notify')
        };
        this._mode = document.hidden === undefined ? false : document.hidden;

        this.listenTo(Backbone, 'favicon:notify', this.setNotificationFavicon);
        this.listenTo(Backbone, 'favicon:normal', this.setNormalFavicon);

        document.addEventListener('visibilitychange', () => {
            if (!document.hidden) {
                this.setNormalFavicon();
            }

            this.setMode(document.hidden);
        });
    },

    setMode(mode) {
        this._mode = Boolean(mode);
    },

    setNotificationFavicon() {
        const favicon = this._$favicon;
        const isFaviconNormal = favicon && favicon.attr('href').indexOf(this._states.notify) === -1;
        const isPageBlurred = this._mode === true;

        if (isFaviconNormal && isPageBlurred) {
            this._$favicon.attr('href', this._states.notify + '?v=' + Date.now());
        }
    },

    setNormalFavicon() {
        const favicon = this._$favicon;
        const isFaviconNotified = favicon && favicon.attr('href').indexOf(this._states.normal) === -1;

        if (isFaviconNotified) {
            this._$favicon.attr('href', this._states.normal + '?v=' + Date.now());
        }
    },

    disableAutoupdateFaviconClient() {
        this.stopListening(Backbone, 'favicon:notify', this.setNotificationFavicon);
        this.stopListening(Backbone, 'favicon:normal', this.setNormalFavicon);

        window.onfocus = this._nativeOnFocusHandler;
    }
};

module.exports = AutoUpdateFaviconMixin;
